﻿namespace Code6587EN.Ch04.DeployBrandingSolution
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Administration;
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.IO;
    using System.Linq;

    /// <summary>
    /// Console Application to apply a Deploy the Custom Branding Solution
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Set the Path to the solution and get the solution name from the path
            var solutionPath = "C:\\Code6587EN.Ch04.wsp";
            var solutionName = Path.GetFileName(solutionPath);

            // Get the local SharePoint farm
            var farm = SPFarm.Local;

            // Get the solution definition from the farm if it exists
            var farmSolution = farm.Solutions[solutionName];

            // If the solution is on the farm, but not deployed, delete it
            if (farmSolution != null && !farmSolution.Deployed)
            {
                farmSolution.Delete();
                farmSolution = null;
            }
                        
            if (farmSolution == null)
            {
                // Add the solution to the farm
                farmSolution = farm.Solutions.Add(solutionPath);

                // If the solution contains Web Application resources, deploy to all content web applications
                // Otherwise deploy globally
                if (farmSolution.ContainsWebApplicationResource)
                {
                    var webApps = new Collection<SPWebApplication>();
                    foreach (SPWebApplication webApp in SPWebService.ContentService.WebApplications)
                        webApps.Add(webApp);
                    farmSolution.Deploy(DateTime.Now, true, webApps, false);
                }
                else
                {
                    farmSolution.Deploy(DateTime.Now, true, false);
                }
            }
            else
            {
                // Upgrade the solution on the farm
                farmSolution.Upgrade(solutionPath, DateTime.Now);
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
